-- DEV-31772 : Response table triggers for modif logs are not optimized


--Create [TrackedQuestionList] table
IF EXISTS(SELECT 1 FROM sys.Objects WHERE  Object_id = OBJECT_ID(N'dbo.TrackedQuestionList') AND Type = N'U')
BEGIN
   Drop table TrackedQuestionList
END

CREATE TABLE [dbo].[TrackedQuestionList](
	[Question] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_TrackedQuestionList] PRIMARY KEY CLUSTERED 
(
	[Question] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO




--Dropping Old Triggers
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'VX_TR_ResponseModifLog_Insert' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[VX_TR_ResponseModifLog_Insert];
END;

IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'VX_TR_ResponseModifLog_Update' AND [type] = 'TR')
BEGIN
      DROP TRIGGER [dbo].[VX_TR_ResponseModifLog_Update];
END;


--Creating new triggers
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'VX_TR_ResponseModifLogT1_Insert' AND [type] = 'TR')
BEGIN
	DROP TRIGGER [dbo].[VX_TR_ResponseModifLogT1_Insert];
END
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'VX_TR_ResponseModifLogT1_Update' AND [type] = 'TR')
BEGIN
	DROP TRIGGER [dbo].[VX_TR_ResponseModifLogT1_Update];
END
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'VX_TR_ResponseModifLogT2_Insert' AND [type] = 'TR')
BEGIN
	DROP TRIGGER [dbo].VX_TR_ResponseModifLogT2_Insert;
END
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'VX_TR_ResponseModifLogT2_Update' AND [type] = 'TR')
BEGIN
	DROP TRIGGER [dbo].VX_TR_ResponseModifLogT2_Update;
END
GO

CREATE TRIGGER [dbo].[VX_TR_ResponseModifLogT1_Insert]
	ON  [dbo].[Response]
	AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	INSERT INTO dbo.ResponseModifLog 
			(Respondent, Question, Matrix, Mention, Content, OldContent, 
			OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
		SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, NULL, 
				inserted.RpsOpened, NULL, inserted.[Source], isnull(inserted.modifiedby,''), inserted.modified, inserted.CallId
		FROM inserted

END

GO
CREATE TRIGGER [dbo].[VX_TR_ResponseModifLogT1_Update]
   ON  [dbo].[Response]
   AFTER UPDATE
AS 
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;

    INSERT INTO dbo.ResponseModifLog 
          (Respondent, Question, Matrix, Mention, Content, OldContent, 
           OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
      SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, deleted.RpsContent, 
             inserted.RpsOpened, deleted.RpsOpened, inserted.[Source], isnull(inserted.modifiedby,''), inserted.modified, inserted.CallId
      FROM inserted left join deleted
      ON inserted.RpsRespondent = deleted.RpsRespondent and 
         inserted.RpsQuestion = deleted.RpsQuestion and 
         inserted.RpsMatrix = deleted.RpsMatrix and 
         inserted.RpsMention = deleted.RpsMention and 
         inserted.RpsType = deleted.RpsType
      WHERE ( inserted.RpsContent<>isnull(deleted.RpsContent,'') ) or (inserted.RpsOpened <> isnull(deleted.RpsOpened,'') )
END
GO



CREATE TRIGGER [dbo].[VX_TR_ResponseModifLogT2_Insert]
	ON  [dbo].[Response]
	AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	INSERT INTO dbo.ResponseModifLog 
			(Respondent, Question, Matrix, Mention, Content, OldContent, 
			OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
		SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, NULL, 
				inserted.RpsOpened, NULL, inserted.[Source], isnull(inserted.modifiedby,''), inserted.modified, inserted.CallId
		FROM inserted
	WHERE EXISTS (SELECT 1 FROM TrackedQuestionList WHERE Question = inserted.RpsQuestion)
END                  

GO
CREATE TRIGGER [dbo].[VX_TR_ResponseModifLogT2_Update]
   ON  [dbo].[Response]
   AFTER UPDATE
AS 
BEGIN
  -- SET NOCOUNT ON added to prevent extra result sets from
  -- interfering with SELECT statements.
  SET NOCOUNT ON;
    INSERT INTO dbo.ResponseModifLog 
          (Respondent, Question, Matrix, Mention, Content, OldContent, 
           OpenEnd, OldOpenEnd, [Source], ModifiedBy, Modified, CallId)
      SELECT inserted.RpsRespondent, inserted.RpsQuestion, inserted.RpsMatrix, inserted.RpsMention, inserted.RpsContent, deleted.RpsContent, 
             inserted.RpsOpened, deleted.RpsOpened, inserted.[Source], isnull(inserted.modifiedby,''), inserted.modified, inserted.CallId
      FROM inserted left join deleted
      ON inserted.RpsRespondent = deleted.RpsRespondent and 
         inserted.RpsQuestion = deleted.RpsQuestion and 
         inserted.RpsMatrix = deleted.RpsMatrix and 
         inserted.RpsMention = deleted.RpsMention and 
         inserted.RpsType = deleted.RpsType
      WHERE ((inserted.RpsContent<>isnull(deleted.RpsContent,'')) or (inserted.RpsOpened <> isnull(deleted.RpsOpened,'')))
     and EXISTS (SELECT 1 FROM TrackedQuestionList WHERE Question = inserted.RpsQuestion)

END
GO


--Disabling all response tracking triggers
ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT1_Insert]
ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT1_Update]
ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT2_Insert]
ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT2_Update]



--Creating The SP responsable for setting the options
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Vx_Sp_SetResponseTrackingOption]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [dbo].[Vx_Sp_SetResponseTrackingOption]
GO

CREATE  PROCEDURE [dbo].[Vx_Sp_SetResponseTrackingOption]
AS
BEGIN

	--Fetch the options
	DECLARE @AuditOn varchar(250)
	SET @AuditOn = (SELECT Installation.InsValue 
					FROM Installation 
					WHERE Installation.InsSection='PROJECT' and
						Installation.InsIdent='TRACK RESPONSE MODIFICATIONS')
	SET @AuditOn = IsNull(@AuditOn, '0')

	--SELECT INSVALUE FROM Installation WHERE INSSECTION = 'TRACKRESPONSE' and INSIDENT LIKE 'QUESTION![%!]' 


	--Disabling all response tracking triggers
	ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT1_Insert]
	ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT1_Update]
	ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT2_Insert]
	ALTER TABLE [dbo].[Response] DISABLE TRIGGER [VX_TR_ResponseModifLogT2_Update]

	If ( @AuditOn = '1' )
	begin
		ALTER TABLE [dbo].[Response] ENABLE TRIGGER [VX_TR_ResponseModifLogT1_Insert]
		ALTER TABLE [dbo].[Response] ENABLE TRIGGER [VX_TR_ResponseModifLogT1_Update]
	end

	If ( @AuditOn = '2' )
	begin
		delete  from TrackedQuestionList

		INSERT INTO TrackedQuestionList
		SELECT InsValue FROM  Installation WHERE (INSSECTION = 'TrackResponse') AND (INSIDENT LIKE 'QUESTION%');
		
		ALTER TABLE [dbo].[Response] ENABLE TRIGGER [VX_TR_ResponseModifLogT2_Insert]
		ALTER TABLE [dbo].[Response] ENABLE TRIGGER [VX_TR_ResponseModifLogT2_Update]
	end


	--Empty question list table
END
GO



--Create a Trigger on the installation table to track changes in response modif log options
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'VX_TR_SetResponseTrackingOption' AND [type] = 'TR')
BEGIN
	DROP TRIGGER [dbo].[VX_TR_SetResponseTrackingOption];
END
GO
CREATE TRIGGER [dbo].[VX_TR_SetResponseTrackingOption]
   ON  [dbo].[Installation]
   AFTER INSERT,DELETE,UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	IF EXISTS (SELECT * from inserted  where InsIdent = 'TRACK RESPONSE MODIFICATIONS' or InsSection =  'TRACKRESPONSE' )
	BEGIN
	    Exec [dbo].[Vx_Sp_SetResponseTrackingOption];
	END
	ELSE IF EXISTS ( SELECT * from deleted  where InsIdent = 'TRACK RESPONSE MODIFICATIONS' or InsSection =  'TRACKRESPONSE')
	BEGIN
	    Exec [dbo].[Vx_Sp_SetResponseTrackingOption];
	END

   
END
GO




-- Execute the [Vx_Sp_SetResponseTrackingOption]
Exec [dbo].[Vx_Sp_SetResponseTrackingOption]
GO



